#ifndef _ENTRY_CPP
#define _ENTRY_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"

#include "NSWFL.H"
#include "Entry.H"
#include "Init.H"
#include "Routines.H"
#include "WinService.H"
#include "Console.H"

#include "../CSockSrvr/CSockSrvr.H"

#include "../Dialogs/MainDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

HINSTANCE ghAppInstance = NULL;

char gsAppCopyRight[64];
char gsFileVersion[32];
char gsTitleCaption[64];
char gsRegistryKey[255];

bool gbIsMainDialogOpen = false;

_MainDialogInfo MDI;
_ConnectedClientInfo CCI;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevious, LPSTR sCmdLine, int iCmdShow)
//int main(void)
{
	int iReturnVal = 0;
	
	ghAppInstance = hInstance;
	//ghAppInstance = GetModuleHandle(NULL);

	if(!InitializeApp())
    {
        return 1;
    }

	//iReturnVal = StartRoutine("/nonservice");
	iReturnVal = StartRoutine(sCmdLine);

	if(!UninitializeApp())
    {
        return 1;
    }

	return iReturnVal;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int StartRoutine(char *sCmdLine)
{
    //----(Debug Code Start)
    if(strcmp(LCase(sCmdLine), "/nonservice") == 0)
    {
        gbRunningAsService = false;
		ServiceThread_Handle = CreateThread(NULL ,0, ServiceThread,(LPVOID)0, 0, &ServiceThread_ID);
        DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_MAIN), 0, MainDialog);
        WaitOnApplicationToExit();
        return _Success_;
    }
	else{
		gbRunningAsService = true;
	}
    //----(Debug Code Stop)

	int Length		   = 0;
	short Result	   = 0;
	LONG LastError     = 0;
    HANDLE MutexHandle = NULL;

    if(IsWinNT() != true)
    {
        MessageBox(NULL, "This application was designed to run only on NT based systems.", gsTitleCaption, MB_SYSTEMMODAL + MB_TASKMODAL);
        return _Error_;
    }

    //-------------------------------------------------------------------------------

    SECURITY_DESCRIPTOR SD;
   	SECURITY_ATTRIBUTES SA;

   	if(InitializeSecurityDescriptor(&SD, SECURITY_DESCRIPTOR_REVISION) == FALSE)
   		return _Error_;

   	if(SetSecurityDescriptorDacl(&SD, TRUE, 0, FALSE) == FALSE)
   		return _Error_;

   	SA.nLength				= sizeof(SA);
   	SA.lpSecurityDescriptor = &SD;
   	SA.bInheritHandle		= FALSE;
    MutexHandle = CreateMutex(&SA, FALSE, gsTitleCaption);

	LastError = GetLastError();
	if(MutexHandle != 0)
	{
		if(LastError == ERROR_ALREADY_EXISTS)
        {
			MessageBox(NULL, "Application already running.", gsTitleCaption, MB_SYSTEMMODAL + MB_TASKMODAL);
			return _Error_;
		}
	}

    //-------------------------------------------------------------------------------

	Result = xServiceEntry(sCmdLine);

	if(Result == _Success_)
    {
    	ReleaseMutex(MutexHandle);
    	CloseHandle(MutexHandle);

        return(_Success_);
    }
	else if(Result == _Error_)
    {
    	ReleaseMutex(MutexHandle);
    	CloseHandle(MutexHandle);

        return(_Error_);
    }

	return _Error_;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool xMainEntry(void)
{
    gbApplicationRunning = true;

	WriteSysLog("Client started.");

	if(!gServer.Start(0))
	{
		WriteSysLog("Failed to start the client.");
	    gbApplicationRunning = false;
		return false;
	}

	Timer_Thread_Handle = CreateThread(NULL, 0, Timer_Thread, (LPVOID)0, 0, &Timer_Thread_ID);

	while(!gbKillApplication)
    {
    	if(WaitForSingleObject(OpenMainDialog_Handle, 0) == WAIT_OBJECT_0)
        {
			DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_MAIN), NULL, MainDialog);
        }

        Sleep(1);
    }
	WriteSysLog("Client Stopped.");

    if(!gServer.Stop())
	{
		WriteSysLog("Failed to stop the client.");
	    gbApplicationRunning = false;
		return false;
	}

	gbApplicationRunning = false;
    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#endif

